const lngs = {
    en: { nativeName: "English" },
    ru: { nativeName: "Pyccкий" },
    cn: { nativeName: "中文 (繁體)" },
    es: { nativeName: "Español" },
    tr: { nativeName: "Türkçe" },
    pt: { nativeName: "Português" }
};

$(function () {
    i18next
        .use(i18nextBrowserLanguageDetector)
        .use(i18nextHttpBackend)
        .init(
            {
                load: "languageOnly",
                fallbackLng: "en",
                detection: {
                    // order and from where user language should be detected
                    order: [
                        "querystring",
                        "cookie",
                        "localStorage",
                        "navigator",
                        "htmlTag",
                    ],
                    // keys or params to lookup language from
                    lookupQuerystring: "lng",
                    lookupCookie: "i18next",
                    lookupLocalStorage: "i18nextLng",
                    // cache user language on
                    caches: ["localStorage", "cookie"],
                    excludeCacheFor: ["cimode"], // languages to not persist (cookie, localStorage)
                    cookieMinutes: 10,
                },
                backend: {
                    loadPath: "locales/{{lng}}/{{ns}}.json",
                },
            },
            function () {
                jqueryI18next.init(i18next, $, { useOptionsAttr: true });

                $("div[aria-live=polite]").click((a, b, c) => {
                    i18next.changeLanguage($(a.target).attr("lang"), () => {
                        $("#lang").text(lngs[i18next.language].nativeName);
                        $("title").text($.t("head.title"));
                        $("body").localize();
                        $(a.currentTarget).fadeToggle("fast", "linear");
                    });
                });

                $("title").text($.t("head.title"));
                $("#lang").text(lngs[i18next.language].nativeName);
                $("body").localize();
            }
        );

    $("div[class=popover_label]").on("click", function (e) {
        
        $("div[aria-live=polite]").fadeToggle("fast", "linear");
    });
    

});